/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.sonar.api.utils.ZipUtils;
import org.sonarsource.sonarlint.core.plugin.ExplodedPlugin;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;

public abstract class PluginJarExploder {
    protected static final String LIB_RELATIVE_PATH_IN_JAR = "META-INF/lib";

    public abstract ExplodedPlugin explode(PluginInfo var1);

    protected ZipUtils.ZipEntryFilter newLibFilter() {
        return ZipLibFilter.INSTANCE;
    }

    protected ExplodedPlugin explodeFromUnzippedDir(String pluginKey, File jarFile, File unzippedDir) {
        File libDir = new File(unzippedDir, LIB_RELATIVE_PATH_IN_JAR);
        Collection<File> libs = libDir.isDirectory() && libDir.exists() ? FileUtils.listFiles(libDir, null, false) : Collections.emptyList();
        return new ExplodedPlugin(pluginKey, jarFile, libs);
    }

    private static enum ZipLibFilter implements ZipUtils.ZipEntryFilter
    {
        INSTANCE;


        @Override
        public boolean accept(ZipEntry entry) {
            return entry.getName().startsWith(PluginJarExploder.LIB_RELATIVE_PATH_IN_JAR);
        }
    }
}

